<?php
require '../../../zb_system/function/c_system_base.php';
require '../../../zb_system/function/c_system_admin.php';
$zbp->Load();
$action = 'root';
if (!$zbp->CheckRights($action)) {$zbp->ShowError(6);die();}
if (!$zbp->CheckPlugin('tx_user_theme')) {$zbp->ShowError(48);die();}
require './function.php';
header('Content-Type: application/json');
if(!$zbp->ValidToken(GetVars('token','GET'))){$zbp->ShowError(5,__FILE__,__LINE__);die();}
switch (GetVars('action', 'GET')) {
	case 'load':
		echo json_encode(tx_user_theme_loadFile(GetVars('filename', 'GET')));
		break;
	case 'save':
		echo json_encode(tx_user_theme_saveFile(GetVars('filename', 'GET'), GetVars('content', 'POST')));
		break;
	default:
		break;
}

function tx_user_theme_loadFile($fileName) {
	global $plugin_Path;
	global $extensionTotx_user_theme;
	$fileName = str_replace('..', '', $fileName);
	$return = array(
		'aceMode' => 'plain_text',
		'content' => '',
		'size' => 0,
	);
	$filePath = $plugin_Path . $fileName;
	$extName = pathinfo($filePath, PATHINFO_EXTENSION);
	if (isset($extensionTotx_user_theme[$extName])) {
		$return['aceMode'] = $extensionTotx_user_theme[$extName];
	}
	if (is_file($filePath)) {
		$return['content'] = file_get_contents($filePath);
		$return['size'] = strlen($return['content']);
	}
	return $return;

}

function tx_user_theme_saveFile($fileName, $content) {

	global $plugin_Path;
	global $extensionTotx_user_theme;
	global $zbp;
	$return = array(
		'size' => 0,
	);
	$fileName = str_replace('..', '', $fileName);
	$filePath = $plugin_Path . $fileName;
	$extName = pathinfo($filePath, PATHINFO_EXTENSION);

	if (isset($extensionTotx_user_theme[$extName]) && is_file($filePath)) {
		file_put_contents($filePath, $content);
		$return['size'] = strlen($content);
	}
	return $return;

}