<?php
#注册插件
RegisterPlugin("MessageAvatar","ActivePlugin_MessageAvatar");

function ActivePlugin_MessageAvatar() {

	Add_Filter_Plugin('Filter_Plugin_Zbp_Load','MessageAvatar_Main');
}

function MessageAvatar_Main() {
	global $zbp;
	$zbp->RegBuildModule('comments','BuildModule_Avatarcomments');
	$zbp->header .= "<link rel=\"stylesheet\" href=\"{$zbp->host}zb_users/plugin/MessageAvatar/css/avatar.css\" type=\"text/css\" />\r\n";	

}

function BuildModule_Avatarcomments() {
	global $zbp;

	$i = $zbp->modulesbyfilename['comments']->MaxLi;
	if ($i == 0) $i = 10;
	$comments = $zbp->GetCommentList('*', array(array('=', 'comm_IsChecking', 0)), array('comm_PostTime' => 'DESC'), $i, null);

	$s = '';
	foreach ($comments as $comment) {
		$s .= '<li class="cmtface"><a href="' . $comment->Post->Url .'#cmt' . $comment->ID .'" title="'.$comment->Time('Y年m月d日 H:i:s').'  post by '.$comment->Author->StaticName.'"><img src="'.$comment->Author->Avatar.'" height="36" width="36" class="side_avatar"/>'.$comment->Author->StaticName.'<span class="muted">：<br>' . TransferHTML($comment->Content, '[noenter]') . '</span></a></li>';
	}

	return $s;
}

function InstallPlugin_MessageAvatar() {
	global $zbp;
//	$zbp->RegBuildModule('comments','BuildModule_Avatarcomments');
	$zbp->AddBuildModule('comments');
}

function UninstallPlugin_MessageAvatar() {
	global $zbp;
	$zbp->RegBuildModule('comments','BuildModule_comments');
	$zbp->AddBuildModule('comments');
}
